<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
  xmlns:my="http://alexfung.info/"
>
<xsl:param name="zoomItem"></xsl:param>
<xsl:output method="html" />

<xsl:template match="/ShadowPlanFile">
  <html>
    <head>
      <link rel="stylesheet" href="ShadP-xslt.css" type="text/css"/>
      <style id="outline"/>
      <style id="stChecked">
        li.checked {display: block}
        span.checked1 {display: inline}
        span.checked2 {display: none}
      </style>
      <script src="daisy.js"/>
      <script src="outline.js"/>
      <script src="breaknote.js"/>
      <script src="pdadate.js"/>
      <script src="tag.js"/>
      <script src="zoom.js"/>
    </head>
    <body>
      <input type="button" id="inBUhud" onclick="evInBUhud()" value="Show Commands" /><br/>
      <xsl:text disable-output-escaping = "yes"><![CDATA[
        <script>
          function evInBUhud() {
            if (diHUD.style.display == "none") {
              inBUhud.value = "Hide Commands";
              diHUD.style.display = "";
            } else {
              inBUhud.value = "Show Commands";
              diHUD.style.display = "none";
            }
          }
        </script>
      ]]></xsl:text>
      <div id="diHUD" style="display:none">
        <span class="checked1">Clear</span><span class="checked2">Mark</span> this checkbox <input type="checkbox" id="inCB" onclick="evInCB()"/> to <span class="checked1">hide</span><span class="checked2">show</span> checked items<br/>
        <xsl:text disable-output-escaping = "yes"><![CDATA[
          <script>
            function evInCB() {
              var r=document.styleSheets.stChecked.rules;
              if (inCB.checked) {
                r(0).style.display = "none";
                r(1).style.display = "none";
                r(2).style.display = "";
              } else {
                r(0).style.display = "";
                r(1).style.display = "";
                r(2).style.display = "none";
              }
            }
          </script>
        ]]></xsl:text>
        Press <input type="button" id="inBU1" onclick="evInBU1()" value="here" /> to expand all collapsed items.<br/>
        Press <input type="button" id="inBU2" onclick="evInBU2()" value="here" /> to collapse all items.<br/>
        Press <input type="button" id="inBU3" onclick="evInBU3()" value="here" /> to open another SP list.<br/>
      </div>
      <xsl:text disable-output-escaping = "yes"><![CDATA[
        <script>
          function evInBU(v) {
            var d=document.all.tags("UL");
            var l = d.length;
            for (i = 1; i < l; i++) {
              d[i].style.display = v;
            }
          }
          function evInBU1() { 
            evInBU("block");
          }
          function evInBU2() {
            evInBU("none");
          }
          function evInBU3() {
            top.document.body.rows = "*,0";
          }
        </script>
      ]]></xsl:text>
      <ul>
        <xsl:if test="$zoomItem">
          <xsl:element name="span">
            <xsl:attribute name="uniqueID"><xsl:value-of select="$zoomItem" /></xsl:attribute>
            <xsl:attribute name="id">spZoomItem</xsl:attribute>
          </xsl:element>
          <xsl:apply-templates select="//item[@uniqueID = $zoomItem]" />
        </xsl:if>
        <xsl:if test="not($zoomItem)">
          <xsl:apply-templates select="item" />
        </xsl:if>
      </ul>
    </body>
  </html>
</xsl:template>

<xsl:template match="item">
  <xsl:element name="li">
    <xsl:if test="@checked='yes'">
      <xsl:attribute name="class">checked</xsl:attribute>
    </xsl:if>
    <xsl:element name="div">
      <xsl:attribute name="class">title title<xsl:value-of select="count(ancestor::*)" /></xsl:attribute>
      <xsl:attribute name="uniqueID"><xsl:value-of select="@uniqueID" /></xsl:attribute>
      <xsl:if test="@checked='yes'"><span class="check">&#254; </span></xsl:if>
      <xsl:if test="not(@checked='yes')"><span class="check">o </span></xsl:if>
      <xsl:value-of select="title" />
      [priority <xsl:value-of select="@priority" />]
      <xsl:if test="not(hhTargetTime = 0)">
        [target date: <span id="spDate"><xsl:value-of select="hhTargetTime" /></span>]
      </xsl:if>
      <xsl:if test="linkEAB[@eabType=2]">
        tags:<xsl:for-each select="linkEAB[@eabType=2]"><xsl:text> </xsl:text>{<span id="spTag"><xsl:value-of select="@eabID" /></span>}</xsl:for-each>
      </xsl:if>
      <xsl:if test="item">
        <span class="marker">4</span>
      </xsl:if>
    </xsl:element>
    <div class="note">
      <pre><xsl:value-of select="note" /></pre>
    </div>
    <xsl:element name="ul">
      <xsl:attribute name="id">ul<xsl:value-of select="@uniqueID" /></xsl:attribute>
      <xsl:apply-templates select="item" />
    </xsl:element>
  </xsl:element>
</xsl:template>

</xsl:stylesheet>
