var xmlDOM = new Object();

//
// newXMLDOM() creates a new DOM object
// parameter selects one of three common objects:
//   xml: DOM for xml and xsl (rental model)
//   xsl: free threaded model DOM for xsl which need to be explicitly 
//        compiled to xsl processor.
//        free model is slower than the rental model
//   xslt: xslt template for the xsl processor
//
// if xmlDOM.progidverset is true, the specified version is used.
// otherwise, will test availability of each version
// and sets xmlDOM.progidver to the version found.
// return null if failed to create any.
//
// to hardcode XML version, caller should assign like this
//
//  xmlDOM.progidverset=true;
//  xmlDOM.progidver=".3.0";

function newXMLDOM(t) {
  function testver(s) {
    var e;
    try { return new ActiveXObject(s); } 
    catch(e) { return null; }
  }
  var s;
  switch (t) {
    case "xml":
      s = "Msxml2.DOMDocument";
      break;
    case "xsl":
      s="Msxml2.FreeThreadedDOMDocument"; 
      // free model required if xsl will compile to xslt
      break;
    case "xslt":
      s="Msxml2.XSLTemplate";
      break;
  }
  var doc;
  if (xmlDOM.progidverset) {
    if (doc = testver(s+xmlDOM.progidver)) return doc;
  }
  xmlDOM.progidverset = true;
  var v=".4.0";
  if (doc = testver(s+v)) {
    doc.setProperty("NewParser", true ); // 4.0 only
    // default already = XPath
    xmlDOM.progidver=v;
    return doc;
  }
  v="3.0";
  if (doc = testver(s+v)) {
    xmlDOM.progidver=v;
    return doc;
  }
  if (doc = testver(s)) {
    xmlDOM.progidver="";
    return doc;
  }
  xmlDOM.errmsg = "Failed to create XML DOM";
  xmlDOM.progidverset=false;
  return null;
}

//
// given xml and xsl file name, transform and return the output
// during the process, window.defaultStatus is updated
//
// on error, return null
// detailed message is at xmlDOM.errmsg
//
// if xml is not a string, it is treated as an XMLDOM and used directly
//

function transformXX(xml, xsl) {
  return transformXXp(xml, xsl, null);
}

//
// if xparam not null, it is an array of parm/value pairs
//

function transformXXp(xml, xsl, xparam) {
  // Parse error formatting function
  function reportParseError(error)
  {
    var s = "";
    for (var i=1; i<error.linepos; i++) {
      s += " ";
    }
    r = "<font face=Verdana size=2><font size=4>XML Error loading '" + 
        error.url + "'</font>" +
        "<P><B>" + error.reason + 
        "</B></P></font>";
    if (error.line > 0)
      r += "<font size=3><XMP>" +
      "at line " + error.line + ", character " + error.linepos +
      "\n" + error.srcText +
      "\n" + s + "^" +
      "</XMP></font>";
    return r;
  }

  // Runtime error formatting function
  function reportRuntimeError(exception)
  {
    return "<font face=Verdana size=2><font size=4>XSL Runtime Error</font>" +
        "<P><B>" + exception.description + "</B></P></font>";
  }

  xmlDOM.errmsg = "";

  var xmlDoc;
  if (typeof xml == "string") {
    defaultStatus = "Initialising XML document...";
    xmlDoc = newXMLDOM("xml");
    if (xmlDoc) {
      xmlDoc.async = false;
      defaultStatus = "Loading " + xml + "...";
      xmlDoc.load(xml);
      if (xmlDoc.parseError.errorCode != 0) {
        xmlDOM.errmsg = reportParseError(xmlDoc.parseError);
        xmlDoc = null;
        return null;
      }
    } else return null;
  } 

  defaultStatus = "Initialising XSL document...";
  if (xparam) {
    var xslDoc = newXMLDOM("xsl"); // must use free model to issue parm
    if (xslDoc) {
      xslDoc.async = false;
      defaultStatus = "Loading " + xsl + "...";
      xslDoc.load(xsl);
      if (xslDoc.parseError.errorCode != 0) {
        xmlDOM.errmsg = reportParseError(xslDoc.parseError);
        xslDoc = null;
        return null;
      }
    } else return null;

    defaultStatus = "Initialising XSLT processor...";
    var xslt = newXMLDOM("xslt"); // use template to compile xslt processor

    defaultStatus = "Compiling XSLT...";
    xslt.stylesheet = xslDoc;
    var xslProc = xslt.createProcessor();

    defaultStatus = "Assigning parameters...";
    for (var i = 0; i<xparam.length; i++) {
      xslProc.addParameter(xparam[i].name, xparam[i].value);
    }

  } else {
    var xslDoc = newXMLDOM("xml"); // no need to compile xslt processor
    if (xslDoc) {
      xslDoc.async = false;
      defaultStatus = "Loading " + xsl + "...";
      xslDoc.load(xsl);
      if (xslDoc.parseError.errorCode != 0) {
        xmlDOM.errmsg = reportParseError(xslDoc.parseError);
        xslDoc = null;
        return null;
      }
    } else return null;
  }

  defaultStatus = "Transforming XML by XSLT...";

  var outHTML;
  try { 
    if (xparam) {
      if (typeof xml == "string") xslProc.input = xmlDoc;
      else xslProc.input = xml;
      xslProc.transform();
      outHTML=xslProc.output;         
    } else {
      if (typeof xml == "string") outHTML=xmlDoc.transformNode(xslDoc);
      else outHTML=xml.transformNode(xslDoc);
    }
  } catch (exception) { 
    xmlDOM.errmsg = reportRuntimeError(exception); 
    defaultStatus = "Transformation failed.";
    return null;
  } 
  defaultStatus = xmlDOM.errmsg = "";
  xmlDoc = xslDoc = null;
  return outHTML;
}



//
// similar to (and calls) transformXX()
// but writes result/errmsg to the win handle (3rd argument)
// if win is null, creates a new window for it
// if win is string, open window with this name
// returns the win handle in all cases
//
// win is optional if a name is not required.
// when win is string and contains any "=", will be treated as arg to open()
//
// if win is window handle, will ignore warg
// can't do anything about it
//

function transformXXW(xml, xsl, win, warg) {
  return transformXXpW(xml, xsl, null, win, warg);
}

function transformXXpW(xml, xsl, param, win, warg) {
  var out = transformXXp(xml,xsl, param);
  var winOpenArg = 'links=no, address=no, menubar=no, location=no, toolbar=no, status=yes, resizable=yes, scrollbars=yes';
  if (warg) winOpenArg += "," + warg;
  var w;
  if (!win) {
    w= window.open("","_blank",winOpenArg);
  } else if (typeof win == "string") {
    if (win.indexOf("=") >= 0) {
      w= window.open("","_blank",winOpenArg + "," + win);
    } else {
      w= window.open("",win,winOpenArg);
    }
  } else w=win;
  if (out) {
    var d = w.document.open();
    d.write(out);
    d.close();
  } else {
    var d = w.document.open();
    d.write(xmlDOM.errmsg);
    d.close();
  }
  return w;
}

