  // Source Code for Outlining
  // Alex Fung Dec 1998
  // at http://alexfung.info/js/outline.js
  // Feb 2004 specially adapted for SP XSLT
  
  //
  //  modified Jul 2000 to 
  //    double click body to hide, single click body now is ignored
  //      As a result, you can now select/hilite body text
  //        without the whole paragraph suddenly disappears
  //      However you still flips the display status when you 
  //        select section headings.
  //    use one single function for click and double click
  //    use one single function for mouseover and mouseout
  //  modified Aug 2002 to make a special version for Shadow Plan
  //    the active element is now always a <div class=title>
  //    cursor style is set at mouseover of the active element
  //    if the active element has a trailing <span class=marker>, it is toggled 4/6

  if (document.all) {
    if (typeof spZoomItem == "object") document.styleSheets["outline"].addRule("UL UL UL","display:none");
    else document.styleSheets["outline"].addRule("UL UL","display:none");
    //  UL UL {display: none}
    if (window.DaisyChain) window.DaisyChain.add("load", doOutlineLoad);
    else window.onload = doOutlineLoad;
  }

  // see if a parent of src has tag dest
  function checkParent(src, dest, cl) {
    var classLength = cl?cl.length:0;
    while (src!=null) {
      if (src.tagName == dest) {
        if (cl) {
          if ((src.className.length > classLength) && (src.className.substr(0,classLength) == cl)) return src;
        } else return src;
      }
      src = src.parentElement;
    }
    return null;
  }

  // revised function for SP XSLT: find UL directly from title
  function outUL(srcel) {
    return document.getElementById("ul" + srcel.uniqueID);
  }


  function outline() {     
    var srcTitle = checkParent(event.srcElement, "DIV", "title");
    if (null==srcTitle) return;
    var srcel = checkParent(srcTitle, "LI");
    if (null==srcel) return;

    var el = outUL(srcTitle);
    if (el==null) return;
    
//  outUL returns null if tagName is not UL, so recheck not needed
    if (""==el.style.display) {
      el.style.display = "block";
      srcel.className = (srcel.className == "checked" ? "open checked":"open");
      var elch=srcTitle.children;
      if (elch) {
        var marker = elch[elch.length-1];
        if (marker.className == "marker") marker.innerText = " 6";
      }
    } else {
      el.style.display = "";
      srcel.className = (srcel.className == "open checked" ? "checked":"parent");
      var elch=srcTitle.children;
      if (elch) {
        var marker = elch[elch.length-1];
        if (marker.className == "marker") marker.innerText = " 4";
      }
    }
    event.cancelBubble = true;
  }

  function outover() {     
    var srcTitle = checkParent(event.srcElement, "DIV", "title");
    if (null==srcTitle) return;
    var srcel = checkParent(srcTitle, "LI");
    if (null==srcel) return;
    var el = outUL(srcTitle);
    if (el==null) return;
    if (el.contains(event.srcElement)) return;
    srcTitle.style.color = event.type == 'mouseover' ? "red" : "navy";
    srcTitle.style.cursor = event.type == 'mouseover' ? "hand" : "auto";
    event.cancelBubble = true;
  }

 function doOutlineLoad() {
    // Do Loading
    if (window.DaisyChain) {
      window.DaisyChain.add("mouseover", outover);
      window.DaisyChain.add("mouseout", outover);
      window.DaisyChain.add("click", outline);
    } else {
      document.onclick = outline;
      document.onmouseover = outover;    
      document.onmouseout = outover;
    }
  }

