<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
  xmlns:my="http://alexfung.info/"
>

<xsl:output method="html" />

<xsl:template match="/ShadowPlanFile">
  <html>
    <head>
      <link rel="stylesheet" href="ShadP-xslt.css" type="text/css"/>
      <style id="outline"/>
      <style id="stChecked">
        li.checked {display: block}
        span.checked1 {display: inline}
        span.checked2 {display: none}
      </style>
      <script src="outline.js"/>
      <script src="breaknote.js"/>
    </head>
    <body>
      Click this checkbox <input type="checkbox" id="inCB" onclick="evInCB()"/> to <span class="checked1">hide</span><span class="checked2">show</span> checked items<br/>
      <xsl:text disable-output-escaping = "yes"><![CDATA[
        <script>
          function evInCB() {
            var r=document.styleSheets.stChecked.rules;
            if (inCB.checked) {
              r(0).style.display = "none";
              r(1).style.display = "none";
              r(2).style.display = "";
            } else {
              r(0).style.display = "";
              r(1).style.display = "";
              r(2).style.display = "none";
            }
          }
        </script>
      ]]></xsl:text>
      Press <input type="button" id="inBU1" onclick="evInBU1()" value="here" /> to expand all collapsed items.<br/>
      Press <input type="button" id="inBU2" onclick="evInBU2()" value="here" /> to collapse all items.<br/>
      <xsl:text disable-output-escaping = "yes"><![CDATA[
        <script>
          function evInBU(v) {
            var d=document.all.tags("UL");
            var l = d.length;
            for (i = 1; i < l; i++) {
              d[i].style.display = v;
            }
          }
          function evInBU1() { 
            evInBU("block");
          }
          function evInBU2() {
            evInBU("none");
          }
        </script>
      ]]></xsl:text>
      <ul>
        <xsl:apply-templates select="item" />
      </ul>
    </body>
  </html>
</xsl:template>

<xsl:template match="item">
  <xsl:element name="li">
    <xsl:if test="@checked='yes'">
      <xsl:attribute name="class">checked</xsl:attribute>
    </xsl:if>
    <xsl:element name="div">
      <xsl:attribute name="class">title title<xsl:value-of select="count(ancestor::*)" /></xsl:attribute>
      <xsl:if test="@checked='yes'"><span class="check">&#254; </span></xsl:if>
      <xsl:if test="not(@checked='yes')"><span class="check">o </span></xsl:if>
      <xsl:value-of select="title" />
      <xsl:if test="item">
        <span class="marker">4</span>
      </xsl:if>
    </xsl:element>
    <div class="note">
      <pre><xsl:value-of select="note" /></pre>
    </div>
    <ul>
      <xsl:apply-templates select="item" />
    </ul>
  </xsl:element>
</xsl:template>

</xsl:stylesheet>
