<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
  xmlns:my="http://alexfung.info/"
>

<xsl:output method="html" />

<xsl:template match="/ShadowPlanFile">
  <html>
    <head>
      <link rel="stylesheet" href="ShadP-xslt.css" type="text/css"/>
      <style id="outline" media="screen"/>
      <script src="outline.js"/>
    </head>
    <body>
      <ul>
        <xsl:apply-templates select="item" />
      </ul>
    </body>
  </html>
</xsl:template>

<xsl:template match="item">
  <li>
    <xsl:element name="div">
      <xsl:attribute name="class">title title<xsl:value-of select="count(ancestor::*)" /></xsl:attribute>
      <xsl:value-of select="title" />
      <xsl:if test="item">
        <span class="marker">4</span>
      </xsl:if>
    </xsl:element>
    <div class="note">
      <xsl:value-of select="note" />
    </div>
    <ul>
      <xsl:apply-templates select="item" />
    </ul>
  </li>
</xsl:template>

</xsl:stylesheet>
