  // Source Code for Outlining
  // Alex Fung Dec 1998
  // at http://alexfung.fly.to/xxx/js/outline.js
  // (the xxx is need since 2002 because of a change in fly.to logic
  //
  //  modified Jul 2000 to 
  //    double click body to hide, single click body now is ignored
  //      As a result, you can now select/hilite body text
  //        without the whole paragraph suddenly disappears
  //      However you still flips the display status when you 
  //        select section headings.
  //    use one single function for click and double click
  //    use one single function for mouseover and mouseout
  //  modified Aug 2002 to make a special version for Shadow Plan
  //    the active element is now always a <div class=title>
  //    cursor style is set at mouseover of the active element
  //    if the active element has a trailing <span class=marker>, it is toggled 4/6

  if (document.all) {
    document.styleSheets["outline"].addRule("UL UL","display:none");
    //  UL UL {display: none}
    if (window.DaisyChain) window.DaisyChain.add("load", doOutlineLoad);
    else window.onload = doOutlineLoad;
  }

  // see if a parent of src has tag dest
  function checkParent(src, dest, cl) {
    var classLength = cl?cl.length:0;
    while (src!=null) {
      if (src.tagName == dest) {
        if (cl) {
          if ((src.className.length > classLength) && (src.className.substr(0,classLength) == cl)) return src;
        } else return src;
      }
      src = src.parentElement;
    }
    return null;
  }

  // see if srcel is parent of a UL 
  function outUL(srcel) {
    var pos = srcel.sourceIndex+1;
    var da = document.all;
    var dal = da.length;
    if (pos >= dal) return null;
    while (srcel.contains(da[pos])) {
      if ("UL"==da[pos].tagName) return da[pos];
      if (++pos >= dal) break;
    }
    return null;
  }


  function outline() {     
    var srcTitle = checkParent(event.srcElement, "DIV", "title");
    if (null==srcTitle) return;
    var srcel = checkParent(srcTitle, "LI");
    if (null==srcel) return;

    var el = outUL(srcel);
    if (el==null) return;
    
//  outUL returns null if tagName is not UL, so recheck not needed
    if (""==el.style.display) {
      el.style.display = "block";
      srcel.className = "open";
      var elch=srcTitle.children;
      if (elch) {
        var marker = elch[elch.length-1];
        if (marker.className == "marker") marker.innerText = " 6";
      }
    } else {
      el.style.display = "";
      srcel.className = "parent";
      var elch=srcTitle.children;
      if (elch) {
        var marker = elch[elch.length-1];
        if (marker.className == "marker") marker.innerText = " 4";
      }
    }
    event.cancelBubble = true;
  }

  function outover() {     
    var srcTitle = checkParent(event.srcElement, "DIV", "title");
    if (null==srcTitle) return;
    var srcel = checkParent(srcTitle, "LI");
    if (null==srcel) return;
    var el = outUL(srcel);
    if (el==null) return;
    if (el.contains(event.srcElement)) return;
    srcTitle.style.color = event.type == 'mouseover' ? "red" : "navy";
    srcTitle.style.cursor = event.type == 'mouseover' ? "hand" : "auto";
    event.cancelBubble = true;
  }

 function doOutlineLoad() {
    // Do Loading
    if (window.DaisyChain) {
      window.DaisyChain.add("mouseover", outover);
      window.DaisyChain.add("mouseout", outover);
      window.DaisyChain.add("click", outline);
    } else {
      document.onclick = outline;
      document.onmouseover = outover;    
      document.onmouseout = outover;
    }
  }

